USE [mail]

ALTER TABLE folders ADD parent_id [bigint] NULL;
GO

ALTER TABLE accounting_disclosure ALTER COLUMN recipient nvarchar(max) NULL;
ALTER TABLE accounting_disclosure ALTER COLUMN hash nchar(40) NULL;

/****** Object:  Table [dbo].[patients]  ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[patients](
		[id] [bigint] IDENTITY(1,1) NOT NULL,
		[message_id] [bigint] NOT NULL,
		[given_name] [nvarchar](max) NULL,
		[family_name] [nvarchar](max) NULL,
		[date_of_birth] [bigint] NULL,
		[title] [nvarchar](max) NULL,
		[organization] [nvarchar](max) NULL,
		[file_hash] [nvarchar](60) NULL,
		CONSTRAINT [PK_patients] PRIMARY KEY NONCLUSTERED
		(
				[id] ASC
		)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[patients]  WITH CHECK ADD  CONSTRAINT [FK_patients_messages] FOREIGN KEY([message_id])
REFERENCES [dbo].[messages] ([id])
GO

ALTER TABLE [dbo].[patients] CHECK CONSTRAINT [FK_patients_messages]
GO